/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.internal.action.LogExport;
import de.willuhn.jameica.gui.internal.dialogs.LogDetailDialog;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.logging.Message;
import de.willuhn.logging.targets.Target;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class LogList
extends TablePart {
    private static final int L_INF0 = Level.INFO.getValue();
    private static final int L_DEBUG = Level.DEBUG.getValue();
    private static final int L_WARN = Level.WARN.getValue();
    private static final int L_ERR = Level.ERROR.getValue();
    private static LinkedList<LogObject> last = new LinkedList();
    private LiveTarget target = new LiveTarget();

    public LogList() throws RemoteException {
        super(LogList.init(), (Action)new DetailAction());
        Logger.addTarget((Target)this.target);
        this.addColumn(Application.getI18n().tr("Priorit\u00e4t"), "level");
        this.addColumn(Application.getI18n().tr("Datum"), "date", new DateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")));
        this.addColumn(Application.getI18n().tr("Text"), "text");
        this.setMulti(false);
        this.removeFeature(FeatureSummary.class);
        this.setRememberOrder(false);
        this.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                if (item == null) {
                    return;
                }
                LogObject o = (LogObject)item.getData();
                if (o == null) {
                    return;
                }
                int level = o.message.getLevel().getValue();
                if (level == L_INF0) {
                    return;
                }
                if (level <= L_DEBUG) {
                    item.setForeground(Color.COMMENT.getSWTColor());
                } else if (level == L_WARN) {
                    item.setForeground(Color.LINK_ACTIVE.getSWTColor());
                } else if (level >= L_ERR) {
                    item.setForeground(Color.ERROR.getSWTColor());
                }
            }
        });
        ContextMenu menu = new ContextMenu();
        menu.addItem(new CheckedContextMenuItem(Application.getI18n().tr("\u00d6ffnen"), new DetailAction()));
        menu.addItem(new ContextMenuItem(Application.getI18n().tr("Speichern unter..."), new LogExport()));
        this.setContextMenu(menu);
    }

    private static GenericIterator init() throws RemoteException {
        Message[] messages = Logger.getLastLines();
        GenericObject[] objects = new LogObject[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            objects[i] = new LogObject(messages[i]);
            last.add((LogObject)objects[i]);
        }
        return PseudoIterator.fromArray((GenericObject[])objects);
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Logger.removeTarget((Target)LogList.this.target);
                LogList.this.target = null;
            }
        });
        super.paint(parent);
        this.setTopIndex(this.size() - 1);
    }

    private static class DetailAction
    implements Action {
        private DetailAction() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            if (context == null || !(context instanceof LogObject)) {
                return;
            }
            Message m = ((LogObject)context).message;
            LogDetailDialog d = new LogDetailDialog(m, 1);
            try {
                d.open();
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (OperationCanceledException oce) {
                return;
            }
            catch (Exception e) {
                Logger.error((String)"unable to display message details", (Throwable)e);
            }
        }
    }

    private class LiveTarget
    implements Target {
        private LiveTarget() {
        }

        public void write(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            LogObject lo = new LogObject(message);
                            last.add(lo);
                            LogList.this.addItem(lo);
                            if (last.size() > 100) {
                                LogList.this.removeItem(last.removeFirst());
                            }
                            LogList.this.setTopIndex(LogList.this.size() - 1);
                        }
                        catch (Throwable t) {
                            if (LogList.this.target == null) break block3;
                            Logger.removeTarget((Target)LogList.this.target);
                        }
                    }
                }
            });
        }

        public void close() throws Exception {
        }
    }

    private static class LogObject
    implements GenericObject {
        private Message message = null;

        private LogObject(Message message) {
            this.message = message;
        }

        public Object getAttribute(String name) throws RemoteException {
            if ("date".equals(name)) {
                return this.message.getDate();
            }
            if ("level".equals(name)) {
                return this.message.getLevel().getName();
            }
            return this.message.getText();
        }

        public String getID() throws RemoteException {
            return this.message.toString();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "text";
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof LogObject)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"date", "level", "text"};
        }
    }
}

